/*
 * afegirLocals.java
 *
 * Created on 10 de junio de 2008, 23:47
 */

package actions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import locals.Local;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
/**
 *
 * @author Administrador
 * @version
 */

public class AfegirLocals extends Action {
    
    DataSource ds = null;
    Connection con = null;
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        
        locals.AfegirLocals opcions = (locals.AfegirLocals) form;
        
        try{
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = null;
            Statement sentencia = null;
            ArrayList <Local> localsImmoble;
            ArrayList <Local> localsLliures;
            
            if (request.getSession().getAttribute("sentenciaLocals") != null) {
                sentencia = (Statement) request.getSession().getAttribute("sentenciaLocals");
            } else {
                sentencia = con.createStatement();
            }
            
            localsImmoble = (ArrayList) request.getSession().getAttribute("localsImmoble");
            localsLliures = (ArrayList) request.getSession().getAttribute("localsLliures");
            
            if (request.getParameter("afegirUn") != null) {
                if (opcions.getIdLocalsLliures() == 0) {
                    opcions.setError("<font color='red'>Selecciona un local lliure a afegir al immoble</font>");
                } else {
                    int j = 0;
                    int i = 0;
                    for (Local local : localsLliures) {
                        if ( local.getIdLocal() == opcions.getIdLocalsLliures()) {
                            localsImmoble.add(local);
                            i = j;
                        }
                        j++;
                    }
                    localsLliures.remove(i);
                    //sentencia.addBatch("INSERT INTO immoble_local (id_immoble, id_local) VALUES ("+opcions.getIdLocalsImmoble()+", "+opcions.getIdLocalsLliures()+")");
                }
            }
            
            //Trau un: Pasara un empleat de la llista de seleccionats a la llista normal
            if (request.getParameter("traurerUn") != null) {
                if (opcions.getIdLocalsImmoble() == 0) {
                    opcions.setError("<font color='red'>Selecciona un local del immoble a traurer</font>");
                } else {
                    int j = 0;
                    int i = 0;
                    for (Local local : localsImmoble) {
                        if ( local.getIdLocal() == opcions.getIdLocalsImmoble()) {
                            localsLliures.add(local);
                            i = j;
                        }
                        j++;
                    }
                    localsImmoble.remove(i);
                    //sentencia.addBatch("DELETE FROM immoble_local WHERE id_local = "+opcions.getIdLocalsLliures()+"");
                }
            }
            
            //Afegir tots: Pasara tot cap a la llista de seleccionats
            if (request.getParameter("afegirTots") != null) {
                for (Local local : localsLliures) {
                    localsImmoble.add(local);
                }
                localsLliures.clear();
            }
            
            //Trau tots: Pasara tot cap a la llista de usuaris
            if (request.getParameter("traurerTots") != null) {
                for (Local local : localsImmoble) {
                    localsLliures.add(local);
                }
                localsImmoble.clear();
            }
            
            //guardar:
            if (request.getParameter("guardar") != null) {
                st.executeUpdate("DELETE FROM immoble_local WHERE id_immoble = "+opcions.getIdLocal());
                for (Local local : localsImmoble) {
                    st.executeUpdate("INSERT INTO immoble_local (id_immoble, id_local) VALUES ("+opcions.getIdLocal()+", "+local.getIdLocal()+")");
                }
                opcions.setError("<font color=blue>Canvis guardats satisfactoriament</font>");
                //sentencia.executeBatch();
            }
            
            request.getSession().removeAttribute("localsLliures");
            request.getSession().removeAttribute("localsImmoble");
            
            request.getSession().setAttribute("sentenciaLocals", sentencia);
            request.getSession().setAttribute("localsLliures", localsLliures);
            request.getSession().setAttribute("localsImmoble", localsImmoble);
            
            
            
        }catch(Exception excepcio){
            opcions.setError("<font color='red'>Excepcio ocorreguda en actions.AfegirLocals:<br>" +
                    ""+excepcio.getMessage()+"<br>" +
                    ""+excepcio.getLocalizedMessage()+"</font>");
            
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                opcions.setError("<font color='red'>Excepcio ocorreguda en actions.AfegirLocals:<br>" +
                        ""+excepcio.getMessage()+"<br>" +
                        ""+excepcio.getLocalizedMessage()+"</font>");
                return mapping.findForward("ok");
            }
        }
        return mapping.findForward("ok");
    }
}
